/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.program;

import de.dasdware.fa.Standard;
import de.dasdware.fa.context.Context;
import de.dasdware.fa.context.ContextEvent;
import de.dasdware.fa.context.impl.ContextAdapter;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionBuilder;
import de.dasdware.fa.functions.FunctionExpressionCreator;
import de.dasdware.fa.functions.FunctionFactory;
import de.dasdware.fa.functions.FunctionPoint;
import de.dasdware.fa.functions.FunctionPointType;
import de.dasdware.fa.plotter.JFunctionTreeDrawer;
import de.dasdware.fa.plotter.JPlotter;
import de.dasdware.fa.program.FunctionBuilderRegister;
import de.dasdware.fa.program.Images;
import de.dasdware.fa.program.JAboutDialog;
import de.dasdware.fa.program.JContextTable;
import de.dasdware.fa.program.JFunctionDialog;
import de.dasdware.fa.program.KeyEventDispatcher;
import de.dasdware.fa.program.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JPlotterFrame
extends JFrame {
    private static final long serialVersionUID = 6598135864942896274L;
    private Context context;
    private JPlotter plotter;
    private JContextTable functionsTable;
    private JSplitPane sideBar;
    private JSplitPane splitPane;
    private JFileChooser fileChooser;
    protected AbstractAction exit = new AbstractAction(Messages.getString("JPlotterFrame.15"), Images.loadIcon("icons/door_open.png")){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    };
    protected AbstractAction zoomIn = new AbstractAction(Messages.getString("JPlotterFrame.17"), Images.loadIcon("icons/zoom_in.png")){
        private static final long serialVersionUID = 3661967537666047645L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.zoomRelative(2.0);
        }
    };
    protected AbstractAction zoomOut = new AbstractAction(Messages.getString("JPlotterFrame.19"), Images.loadIcon("icons/zoom_out.png")){
        private static final long serialVersionUID = 7274934869407921531L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.zoomRelative(0.5);
        }
    };
    protected AbstractAction scrollLeft = new AbstractAction(Messages.getString("JPlotterFrame.21"), null){
        private static final long serialVersionUID = 2631294075205302001L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.move(-JPlotterFrame.this.context.getXScl(), 0.0);
        }
    };
    protected AbstractAction scrollRight = new AbstractAction(Messages.getString("JPlotterFrame.22"), null){
        private static final long serialVersionUID = -5862454032708218608L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.move(JPlotterFrame.this.context.getXScl(), 0.0);
        }
    };
    protected AbstractAction scrollUp = new AbstractAction(Messages.getString("JPlotterFrame.23"), null){
        private static final long serialVersionUID = 3683236639634152794L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.move(0.0, JPlotterFrame.this.context.getYScl());
        }
    };
    protected AbstractAction scrollDown = new AbstractAction(Messages.getString("JPlotterFrame.24"), null){
        private static final long serialVersionUID = -7092542337970576653L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.context.move(0.0, -JPlotterFrame.this.context.getYScl());
        }
    };
    protected AbstractAction addFunction = new AbstractAction(Messages.getString("JPlotterFrame.25"), Images.loadIcon("icons/chart_line_add.png")){
        private static final long serialVersionUID = -8750139249411947529L;

        public void actionPerformed(ActionEvent arg0) {
            if (JFunctionDialog.createFunction(JPlotterFrame.this, Messages.getString("JPlotterFrame.27"), JPlotterFrame.this.context)) {
                JPlotterFrame.this.context.addFunction(JFunctionDialog.getLastFunction());
            }
        }
    };
    protected AbstractAction editFunction = new AbstractAction(Messages.getString("JPlotterFrame.28"), Images.loadIcon("icons/chart_line_edit.png")){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            Function old = JPlotterFrame.this.functionsTable.getSelectedFunction();
            if (old != null && JFunctionDialog.editFunction(JPlotterFrame.this, Messages.getString("JPlotterFrame.30"), old, JPlotterFrame.this.context)) {
                JPlotterFrame.this.context.exchangeFunction(old, JFunctionDialog.getLastFunction());
            }
        }
    };
    protected AbstractAction delFunction = new AbstractAction(Messages.getString("JPlotterFrame.31"), Images.loadIcon("icons/chart_line_delete.png")){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            Function del = JPlotterFrame.this.functionsTable.getSelectedFunction();
            if (del != null) {
                JPlotterFrame.this.context.removeFunction(del);
            }
        }
    };
    protected AbstractAction trackMouseNone = new AbstractAction(Messages.getString("JPlotterFrame.33"), null){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.plotter.setTrackMode(0);
        }
    };
    protected AbstractAction trackMouseFree = new AbstractAction(Messages.getString("JPlotterFrame.34"), null){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.plotter.setTrackMode(1);
        }
    };
    protected AbstractAction trackMouseFunc = new AbstractAction(Messages.getString("JPlotterFrame.35"), null){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent arg0) {
            JPlotterFrame.this.plotter.setTrackMode(2);
        }
    };
    protected AbstractAction trackMouse = new AbstractAction(Messages.getString("JPlotterFrame.36"), Images.loadIcon("icons/cursor.png")){
        private static final long serialVersionUID = -7948067634910004685L;
        private JPopupMenu menu;
        {
            this.menu = null;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.menu == null) {
                this.menu = new JPopupMenu();
                final JRadioButtonMenuItem trackNone = new JRadioButtonMenuItem(JPlotterFrame.this.trackMouseNone);
                final JRadioButtonMenuItem trackFree = new JRadioButtonMenuItem(JPlotterFrame.this.trackMouseFree);
                final JRadioButtonMenuItem trackFunc = new JRadioButtonMenuItem(JPlotterFrame.this.trackMouseFunc);
                JPlotterFrame.this.plotter.addPropertyChangeListener("JPlotter:property:trackmode", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        switch ((Integer)evt.getNewValue()) {
                            case 0: {
                                trackNone.setSelected(true);
                                break;
                            }
                            case 1: {
                                trackFree.setSelected(true);
                                break;
                            }
                            case 2: {
                                trackFunc.setSelected(true);
                            }
                        }
                    }
                });
                ButtonGroup btns = new ButtonGroup();
                btns.add(trackNone);
                btns.add(trackFree);
                btns.add(trackFunc);
                this.menu.add(trackNone);
                this.menu.add(trackFree);
                this.menu.add(trackFunc);
                trackNone.setSelected(true);
            }
            Component c = (Component)e.getSource();
            int py = c.getY() + c.getHeight();
            this.menu.show(c, 0, py);
        }
    };
    protected AbstractAction toggleSidebar = new AbstractAction(Messages.getString("JPlotterFrame.38"), Images.loadIcon("icons/application_side_list.png")){
        private static final long serialVersionUID = 0L;
        private boolean visible;
        private int pos;
        {
            this.visible = true;
            this.pos = -1;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.visible) {
                this.pos = JPlotterFrame.this.splitPane.getDividerLocation();
                JPlotterFrame.this.sideBar.setVisible(false);
                JPlotterFrame.this.splitPane.setDividerSize(0);
            } else {
                JPlotterFrame.this.splitPane.setDividerSize(4);
                if (this.pos > 0) {
                    JPlotterFrame.this.splitPane.setDividerLocation(this.pos);
                } else {
                    JPlotterFrame.this.splitPane.setDividerLocation(0.3);
                }
                JPlotterFrame.this.sideBar.setVisible(true);
            }
            this.visible = !this.visible;
        }
    };
    protected AbstractAction emptySheet = new AbstractAction(Messages.getString("JPlotterFrame.40"), Images.loadIcon("icons/page_white.png")){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent e) {
            if (JPlotterFrame.this.context.countFunctions() > 0) {
                int d = JOptionPane.showConfirmDialog(JPlotterFrame.this, Messages.getString("JPlotterFrame.42"), Messages.getString("JPlotterFrame.43"), 1);
                switch (d) {
                    case 0: {
                        JPlotterFrame.this.saveToFile.actionPerformed(e);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
                JPlotterFrame.this.context.removeAllFunctions();
            }
        }
    };
    protected AbstractAction saveToFile = new AbstractAction(Messages.getString("JPlotterFrame.44"), Images.loadIcon("icons/disk.png")){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent e) {
            if (JPlotterFrame.this.fileChooser.showSaveDialog(JPlotterFrame.this) == 0) {
                Function f = null;
                FunctionBuilder b = FunctionBuilderRegister.getBuilder(0);
                FunctionExpressionCreator fec = b.getExpressionCreator();
                Properties prop = new Properties();
                prop.put("count", "" + JPlotterFrame.this.context.countFunctions());
                prop.put("builder", b.getClass().getCanonicalName());
                int i = 0;
                Iterator<Function> itf = JPlotterFrame.this.context.functionIterator();
                while (itf.hasNext()) {
                    f = itf.next();
                    prop.put("function" + i + "name", f.getName());
                    prop.put("function" + i + "expr", fec.createExpression(f));
                    ++i;
                }
                try {
                    prop.store(new FileOutputStream(JPlotterFrame.this.fileChooser.getSelectedFile()), "Created with DasdPlotter");
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    };
    protected AbstractAction openFromFile = new AbstractAction(Messages.getString("JPlotterFrame.54"), Images.loadIcon("icons/folder.png")){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent e) {
            JPlotterFrame.this.emptySheet.actionPerformed(e);
            if (JPlotterFrame.this.fileChooser.showOpenDialog(JPlotterFrame.this) == 0) {
                Properties prop = new Properties();
                try {
                    prop.load(new FileInputStream(JPlotterFrame.this.fileChooser.getSelectedFile()));
                }
                catch (FileNotFoundException fnfe) {
                    JPlotterFrame.this.error(Messages.getString("JPlotterFrame.56"));
                    return;
                }
                catch (IOException ioe) {
                    JPlotterFrame.this.error(Messages.getString("JPlotterFrame.57"));
                    return;
                }
                int count = Integer.valueOf(prop.get("count").toString());
                String builderClass = prop.get("builder").toString();
                FunctionBuilder builder = null;
                int i = 0;
                int j = FunctionBuilderRegister.count();
                while (i < j) {
                    if (FunctionBuilderRegister.getBuilder(i).getClass().getCanonicalName().equals(builderClass)) {
                        builder = FunctionBuilderRegister.getBuilder(i);
                        break;
                    }
                    ++i;
                }
                if (builder == null) {
                    JPlotterFrame.this.error(Messages.getString("JPlotterFrame.60"));
                    return;
                }
                i = 0;
                while (i < count) {
                    String name = prop.get("function" + i + "name").toString();
                    String expr = prop.get("function" + i + "expr").toString();
                    Function f = builder.build(expr, name, JPlotterFrame.this.context);
                    JPlotterFrame.this.context.addFunction(f);
                    ++i;
                }
            }
        }
    };
    protected AbstractAction findRoots = new AbstractAction(Messages.getString("JPlotterFrame.65"), null){
        private static final long serialVersionUID = 0L;

        public void actionPerformed(ActionEvent e) {
            Iterator<Function> itf = JPlotterFrame.this.context.functionIterator();
            while (itf.hasNext()) {
                Function subject = itf.next();
                if (!JPlotterFrame.this.context.functionSelected(subject)) continue;
                double[] roots = JPlotterFrame.this.context.getAnalyzer().analyzeRoots(subject, JPlotterFrame.this.context);
                if (roots.length == 0) {
                    JPlotterFrame.this.info(Messages.getString("JPlotterFrame.66"));
                    continue;
                }
                JPlotterFrame.this.context.removePoints(subject, FunctionPointType.ROOT);
                int i = 0;
                while (i < roots.length) {
                    JPlotterFrame.this.context.addPoint(new FunctionPoint(new Function[]{subject}, FunctionPointType.ROOT, roots[i], 0.0));
                    ++i;
                }
            }
        }
    };
    protected AbstractAction findTurningPoints = new AbstractAction(Messages.getString("JPlotterFrame.67"), null){
        private static final long serialVersionUID = -3374957833175135692L;

        public void actionPerformed(ActionEvent e) {
            Iterator<Function> itf = JPlotterFrame.this.context.functionIterator();
            while (itf.hasNext()) {
                Function subject = itf.next();
                if (!JPlotterFrame.this.context.functionSelected(subject)) continue;
                double[] pts = JPlotterFrame.this.context.getAnalyzer().analyzeTurnings(subject, JPlotterFrame.this.context);
                if (pts.length == 0) {
                    JPlotterFrame.this.info(Messages.getString("JPlotterFrame.68"));
                    continue;
                }
                JPlotterFrame.this.context.removePoints(subject, FunctionPointType.TURNING);
                int i = 0;
                while (i < pts.length) {
                    try {
                        double y = subject.getValueAt(pts[i], JPlotterFrame.this.context);
                        JPlotterFrame.this.context.addPoint(new FunctionPoint(new Function[]{subject}, FunctionPointType.TURNING, pts[i], y));
                    }
                    catch (DomainException domainException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    };
    protected AbstractAction findInflectionPoints = new AbstractAction(Messages.getString("JPlotterFrame.69"), null){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent e) {
            Iterator<Function> itf = JPlotterFrame.this.context.functionIterator();
            while (itf.hasNext()) {
                Function subject = itf.next();
                if (!JPlotterFrame.this.context.functionSelected(subject)) continue;
                double[] pts = JPlotterFrame.this.context.getAnalyzer().analyzeInflections(subject, JPlotterFrame.this.context);
                if (pts.length == 0) {
                    JPlotterFrame.this.info(Messages.getString("JPlotterFrame.70"));
                    continue;
                }
                JPlotterFrame.this.context.removePoints(subject, FunctionPointType.INFLECTION);
                int i = 0;
                while (i < pts.length) {
                    try {
                        double y = subject.getValueAt(pts[i], JPlotterFrame.this.context);
                        JPlotterFrame.this.context.addPoint(new FunctionPoint(new Function[]{subject}, FunctionPointType.INFLECTION, pts[i], y));
                    }
                    catch (DomainException domainException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
    };
    protected AbstractAction findIntersections = new AbstractAction(Messages.getString("JPlotterFrame.71"), null){
        private static final long serialVersionUID = -3470084702105806683L;

        public void actionPerformed(ActionEvent arg0) {
            LinkedList<Function> sf = new LinkedList<Function>();
            Iterator<Function> it = JPlotterFrame.this.context.functionIterator();
            while (it.hasNext()) {
                Function f = it.next();
                if (!JPlotterFrame.this.context.functionSelected(f)) continue;
                sf.add(f);
            }
            if (sf.size() > 1) {
                Function[] sfa = new Function[]{};
                sfa = sf.toArray(sfa);
                double[] pts = JPlotterFrame.this.context.getAnalyzer().analyzeIntersections(sfa, JPlotterFrame.this.context);
                if (pts.length == 0) {
                    JPlotterFrame.this.info(Messages.getString("JPlotterFrame.72"));
                } else {
                    int i = 0;
                    while (i < sfa.length) {
                        JPlotterFrame.this.context.removePoints(sfa[i], FunctionPointType.INTERSECTION);
                        ++i;
                    }
                    i = 0;
                    while (i < pts.length) {
                        try {
                            double y = sfa[0].getValueAt(pts[i], JPlotterFrame.this.context);
                            JPlotterFrame.this.context.addPoint(new FunctionPoint(sfa, FunctionPointType.INTERSECTION, pts[i], y));
                        }
                        catch (DomainException domainException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
        }
    };
    protected AbstractAction createTangent = new AbstractAction(Messages.getString("JPlotterFrame.77"), null){
        private static final long serialVersionUID = 183715554503645144L;
        private MouseListener listener;
        {
            this.listener = new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    Point2D.Double p0 = JPlotterFrame.this.plotter.getMousePos();
                    Iterator<Function> itf = JPlotterFrame.this.context.functionIterator();
                    LinkedList<Function> created = new LinkedList<Function>();
                    while (itf.hasNext()) {
                        Function subject = itf.next();
                        if (!JPlotterFrame.this.context.functionSelected(subject)) continue;
                        try {
                            FunctionFactory ff = Standard.functionFactory();
                            double m = ff.createDerivation(subject).getValueAt(p0.x, JPlotterFrame.this.context);
                            p0.y = subject.getValueAt(p0.x, JPlotterFrame.this.context);
                            Function f = ff.createSum(ff.createProduct(ff.createConstant(m), ff.createDifference(ff.createIdentity(), ff.createConstant(p0.x))), ff.createConstant(p0.y));
                            f.setName("T(" + subject.getName() + ", " + Standard.formatNumber(p0.x) + ")");
                            created.add(f);
                        }
                        catch (DomainException ff) {
                            // empty catch block
                        }
                    }
                    Function[] fa = new Function[created.size()];
                    created.toArray(fa);
                    int i = 0;
                    while (i < fa.length) {
                        JPlotterFrame.this.context.addFunction(fa[i]);
                        ++i;
                    }
                    JPlotterFrame.this.plotter.removeMouseListener(this);
                    this.setEnabled(true);
                }
            };
        }

        public void actionPerformed(ActionEvent e) {
            JPlotterFrame.this.plotter.addMouseListener(this.listener);
            this.setEnabled(false);
        }
    };
    protected AbstractAction showFunctionTree = new AbstractAction(Messages.getString("JPlotterFrame.73"), Images.loadIcon("icons/chart_organisation.png")){
        private static final long serialVersionUID = 7684812497674058569L;
        private boolean treeVisible;
        private ListSelectionListener listener;
        {
            this.treeVisible = false;
            this.listener = new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    Function f = JPlotterFrame.this.functionsTable.getSelectedFunction();
                    if (f != null) {
                        int t = JPlotterFrame.this.splitPane.getDividerLocation();
                        JPlotterFrame.this.splitPane.setRightComponent(new JScrollPane(new JFunctionTreeDrawer(f)));
                        JPlotterFrame.this.splitPane.setDividerLocation(t);
                    }
                }
            };
        }

        public void actionPerformed(ActionEvent e) {
            Function f = JPlotterFrame.this.functionsTable.getSelectedFunction();
            if (!this.treeVisible) {
                if (f != null) {
                    int t = JPlotterFrame.this.splitPane.getDividerLocation();
                    JPlotterFrame.this.splitPane.setRightComponent(new JScrollPane(new JFunctionTreeDrawer(f)));
                    JPlotterFrame.this.splitPane.setDividerLocation(t);
                    this.treeVisible = true;
                    JPlotterFrame.this.functionsTable.getSelectionModel().addListSelectionListener(this.listener);
                    JPlotterFrame.this.setPlotterEnabled(false);
                }
            } else {
                JPlotterFrame.this.functionsTable.getSelectionModel().removeListSelectionListener(this.listener);
                int t = JPlotterFrame.this.splitPane.getDividerLocation();
                JPlotterFrame.this.splitPane.setRightComponent(JPlotterFrame.this.plotter);
                JPlotterFrame.this.splitPane.setDividerLocation(t);
                this.treeVisible = false;
                JPlotterFrame.this.setPlotterEnabled(true);
            }
        }
    };
    protected AbstractAction center = new AbstractAction(Messages.getString("JPlotterFrame.75"), Images.loadIcon("icons/arrow_in.png")){
        private static final long serialVersionUID = 2967844384896915683L;

        public void actionPerformed(ActionEvent e) {
            JPlotterFrame.this.context.moveToCenter();
        }
    };
    protected AbstractAction about = new AbstractAction(Messages.getString("JPlotterFrame.81"), Images.loadIcon("icons/information.png")){
        private static final long serialVersionUID = -1678861096201487966L;

        public void actionPerformed(ActionEvent e) {
            JAboutDialog.aboutDialog(JPlotterFrame.this);
        }
    };

    public JPlotterFrame(Dimension setupsize) {
        super(Messages.getString("JPlotterFrame.0"));
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File("."));
        this.context = Standard.createContext();
        this.plotter = new JPlotter(this.context);
        this.plotter.setFocusable(true);
        this.plotter.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JPlotterFrame.this.plotter.requestFocus();
            }
        });
        this.plotter.setCursor(new Cursor(1));
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int top = (d.height - setupsize.height) / 2;
        int left = (d.width - setupsize.width) / 2;
        this.setBounds(new Rectangle(left, top, setupsize.width, setupsize.height));
        this.setDefaultCloseOperation(3);
        JMenuBar menu = new JMenuBar();
        JMenu file = new JMenu(Messages.getString("JPlotterFrame.2"));
        file.add(this.emptySheet);
        file.add(this.openFromFile);
        file.add(this.saveToFile);
        file.add(new JSeparator());
        file.add(this.exit);
        menu.add(file);
        JMenu functions = new JMenu(Messages.getString("JPlotterFrame.3"));
        functions.add(this.addFunction);
        functions.add(this.editFunction);
        functions.add(this.delFunction);
        functions.add(this.showFunctionTree);
        menu.add(functions);
        JMenu maths = new JMenu(Messages.getString("JPlotterFrame.4"));
        maths.add(this.findRoots);
        maths.add(this.findTurningPoints);
        maths.add(this.findInflectionPoints);
        maths.add(this.createTangent);
        maths.add(new JSeparator());
        maths.add(this.findIntersections);
        menu.add(maths);
        JMenu view = new JMenu(Messages.getString("JPlotterFrame.5"));
        JMenu track = new JMenu(this.trackMouse.getValue("Name").toString());
        final JRadioButtonMenuItem trackNone = new JRadioButtonMenuItem(this.trackMouseNone);
        final JRadioButtonMenuItem trackFree = new JRadioButtonMenuItem(this.trackMouseFree);
        final JRadioButtonMenuItem trackFunc = new JRadioButtonMenuItem(this.trackMouseFunc);
        this.plotter.addPropertyChangeListener("JPlotter:property:trackmode", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                switch ((Integer)evt.getNewValue()) {
                    case 0: {
                        trackNone.setSelected(true);
                        break;
                    }
                    case 1: {
                        trackFree.setSelected(true);
                        break;
                    }
                    case 2: {
                        trackFunc.setSelected(true);
                    }
                }
            }
        });
        track.setIcon((Icon)this.trackMouse.getValue("SmallIcon"));
        track.add(trackNone);
        track.add(trackFree);
        track.add(trackFunc);
        ButtonGroup btns = new ButtonGroup();
        btns.add(trackNone);
        btns.add(trackFree);
        btns.add(trackFunc);
        trackNone.setSelected(true);
        view.add(track);
        view.add(this.toggleSidebar);
        view.add(this.zoomIn);
        view.add(this.zoomOut);
        view.add(this.center);
        view.add(new JSeparator());
        view.add(this.scrollLeft);
        view.add(this.scrollRight);
        view.add(this.scrollUp);
        view.add(this.scrollDown);
        menu.add(view);
        JMenu help = new JMenu(Messages.getString("JPlotterFrame.76"));
        help.add(this.about);
        menu.add(help);
        this.setJMenuBar(menu);
        this.setLayout(new BorderLayout());
        KeyEventDispatcher disp = new KeyEventDispatcher();
        disp.addCommand(38, this.scrollUp);
        disp.addCommand(40, this.scrollDown);
        disp.addCommand(37, this.scrollLeft);
        disp.addCommand(39, this.scrollRight);
        disp.addCommand(521, this.zoomIn);
        disp.addCommand(107, this.zoomIn);
        disp.addCommand(45, this.zoomOut);
        disp.addCommand(109, this.zoomOut);
        this.plotter.addKeyListener(disp);
        JPanel statusBar = new JPanel(new FlowLayout(0, 2, 2));
        statusBar.setBorder(BorderFactory.createBevelBorder(1));
        final JLabel statusLabel = new JLabel(Messages.getString("JPlotterFrame.6"));
        this.context.addContextListener(new ContextAdapter(){

            public void displayUpdated(ContextEvent ce) {
                statusLabel.setText(String.valueOf(Messages.getString("JPlotterFrame.7")) + (int)(JPlotterFrame.this.context.getZoom() * 100.0) + "%");
            }
        });
        statusBar.add(statusLabel);
        this.add("South", statusBar);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.emptySheet);
        toolBar.add(this.openFromFile);
        toolBar.add(this.saveToFile);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.addFunction);
        toolBar.add(this.editFunction);
        toolBar.add(this.delFunction);
        toolBar.add(this.showFunctionTree);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.trackMouse);
        toolBar.add(this.toggleSidebar);
        toolBar.add(this.zoomIn);
        toolBar.add(this.zoomOut);
        toolBar.add(this.center);
        toolBar.add(new JToolBar.Separator());
        toolBar.add(this.about);
        toolBar.add(this.exit);
        this.add("North", toolBar);
        JPanel functionPanel = new JPanel(new BorderLayout());
        functionPanel.add("North", new JLabel(Messages.getString("JPlotterFrame.9")));
        this.functionsTable = new JContextTable(this.context, JContextTable.Type.FUNCTIONS);
        functionPanel.add("Center", new JScrollPane(this.functionsTable));
        JPanel pointPanel = new JPanel(new BorderLayout());
        pointPanel.add("North", new JLabel(Messages.getString("JPlotterFrame.10")));
        JContextTable pointsTable = new JContextTable(this.context, JContextTable.Type.POINTS);
        pointPanel.add("Center", new JScrollPane(pointsTable));
        this.sideBar = new JSplitPane(0, true, functionPanel, pointPanel);
        this.sideBar.setDividerSize(4);
        this.splitPane = new JSplitPane(1, true, this.sideBar, this.plotter);
        this.splitPane.setDividerLocation(0.3);
        this.add("Center", this.splitPane);
        this.splitPane.setDividerSize(4);
        this.setVisible(true);
        this.splitPane.setDividerLocation(0.3);
        this.sideBar.setDividerLocation(0.5);
    }

    protected void error(String message) {
        JOptionPane.showMessageDialog(this, message, Messages.getString("JPlotterFrame.13"), 0);
    }

    protected void info(String message) {
        JOptionPane.showMessageDialog(this, message, Messages.getString("JPlotterFrame.14"), 1);
    }

    private void setPlotterEnabled(boolean enabled) {
        this.center.setEnabled(enabled);
        this.scrollLeft.setEnabled(enabled);
        this.scrollRight.setEnabled(enabled);
        this.scrollUp.setEnabled(enabled);
        this.scrollDown.setEnabled(enabled);
        this.zoomIn.setEnabled(enabled);
        this.zoomOut.setEnabled(enabled);
        this.trackMouse.setEnabled(enabled);
        this.trackMouseFree.setEnabled(enabled);
        this.trackMouseFunc.setEnabled(enabled);
        this.trackMouseNone.setEnabled(enabled);
        this.findInflectionPoints.setEnabled(enabled);
        this.findRoots.setEnabled(enabled);
        this.findIntersections.setEnabled(enabled);
        this.findTurningPoints.setEnabled(enabled);
        this.createTangent.setEnabled(enabled);
    }
}

