/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.program;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JOptionPanel
extends JPanel {
    private static final long serialVersionUID = -7494273537708600891L;
    private String m_sText = null;
    private boolean m_fInitDone = false;
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;

    public JOptionPanel() {
        this((String)null);
    }

    public JOptionPanel(String text) {
        this(text, 16, 4);
    }

    public JOptionPanel(String text, int hgap, int vgap) {
        this(text, hgap, vgap, 1, 3);
    }

    public JOptionPanel(String text, int hgap, int vgap, int horizAlign, int vertAlign) {
        this.setText(text);
        this.setLayout(new OptionLayout(hgap, vgap, horizAlign, vertAlign));
        this.m_fInitDone = true;
    }

    public void setText(String text) {
        this.m_sText = text;
        if (text != null) {
            this.setBorder(BorderFactory.createTitledBorder(this.m_sText));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    public String getText() {
        return this.m_sText;
    }

    public void addOption(String title, JComponent component) {
        JLabel label = new JLabel("", 4);
        if (!title.equals("")) {
            label.setText(" " + title + ":");
        }
        this.add(label);
        this.add(component);
    }

    public void addOption(String title, Object text) {
        this.addOption(title, new JLabel(text.toString()));
    }

    public Component getOptionComponent(int n) {
        return this.getComponent(n * 2 + 1);
    }

    public void setLayout(LayoutManager mgr) {
        if (!this.m_fInitDone) {
            super.setLayout(mgr);
            return;
        }
        throw new UnsupportedOperationException("This does not allow to change the layout manager. Choose JPanel instead");
    }

    private class OptionLayout
    implements LayoutManager {
        private int m_nHgap;
        private int n_nVgap = 0;
        private int m_nHorizontalAlign;
        private int m_nVerticalAlign;

        public OptionLayout(int hgap, int vgap, int horiz, int vert) {
            this.n_nVgap = vgap;
            this.m_nHgap = hgap;
            this.m_nHorizontalAlign = horiz;
            this.m_nVerticalAlign = vert;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets ins = parent.getInsets();
                int n = parent.getComponentCount() / 2;
                int wl = 0;
                int wr = 0;
                int h = 0;
                int count = parent.getComponentCount();
                int i = 0;
                while (i < count) {
                    int lcw = parent.getComponent((int)i).getPreferredSize().width;
                    if (lcw > wl) {
                        wl = lcw;
                    }
                    i += 2;
                }
                i = 0;
                while (i < count) {
                    int rcw = parent.getComponent((int)(i + 1)).getPreferredSize().width;
                    if (rcw == Integer.MAX_VALUE && parent.getSize().width > 0) {
                        rcw = parent.getSize().width - wl - this.m_nHgap;
                    }
                    if (rcw > wr) {
                        wr = rcw;
                    }
                    h = parent.getComponent((int)(i + 1)).getPreferredSize().height == Integer.MAX_VALUE ? (h += parent.getSize().height) : (h += parent.getComponent((int)(i + 1)).getPreferredSize().height);
                    i += 2;
                }
                int w = wl + wr + this.m_nHgap;
                return new Dimension(w, h += (n - 1) * this.n_nVgap + ins.top + ins.bottom);
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets ins = parent.getInsets();
                int topoffset = 0;
                int leftoffset = 0;
                Dimension pref = this.preferredLayoutSize(parent);
                switch (this.m_nHorizontalAlign) {
                    case 1: {
                        leftoffset = 0;
                        break;
                    }
                    case 0: {
                        if (parent.getSize().width <= pref.width) break;
                        leftoffset = (parent.getSize().width - pref.width - ins.left - ins.right) / 2;
                        break;
                    }
                    case 2: {
                        if (parent.getSize().width <= pref.width) break;
                        leftoffset = parent.getSize().width - pref.width - ins.right - this.m_nHgap;
                    }
                }
                switch (this.m_nVerticalAlign) {
                    case 3: {
                        topoffset = 0;
                        break;
                    }
                    case 0: {
                        if (parent.getSize().height <= pref.height) break;
                        topoffset = (parent.getSize().height - pref.height - ins.top - ins.bottom) / 2;
                        break;
                    }
                    case 4: {
                        if (parent.getSize().height <= pref.height) break;
                        topoffset = parent.getSize().height - pref.height - ins.bottom;
                    }
                }
                int leftsize = 0;
                int top = ins.top + topoffset;
                int heightleft = parent.getSize().height - ins.top - ins.bottom;
                int i = 0;
                while (i < parent.getComponentCount()) {
                    Component comp = parent.getComponent(i);
                    if (comp.getPreferredSize().width > leftsize) {
                        leftsize = comp.getPreferredSize().width;
                    }
                    i += 2;
                }
                int rightsize = parent.getSize().width - leftsize - ins.left - ins.right - this.m_nHgap;
                int i2 = 0;
                while (i2 < parent.getComponentCount()) {
                    Component compleft = parent.getComponent(i2);
                    Component compright = parent.getComponent(i2 + 1);
                    int height = compright.getPreferredSize().height;
                    if (height == Integer.MAX_VALUE) {
                        height = heightleft;
                        heightleft = 0;
                    } else {
                        heightleft -= height + this.n_nVgap;
                    }
                    compleft.setBounds(ins.left, top, leftsize + leftoffset, compleft.getPreferredSize().height);
                    if (compright.getPreferredSize().width == Integer.MAX_VALUE) {
                        compright.setBounds(this.m_nHgap + ins.left + leftsize + leftoffset, top, rightsize, height);
                    } else {
                        compright.setBounds(this.m_nHgap + ins.left + leftsize + leftoffset, top, compright.getPreferredSize().width, height);
                    }
                    top += height + this.n_nVgap;
                    if (heightleft == 0) break;
                    i2 += 2;
                }
            }
        }
    }
}

