/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.program;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionBuilder;
import de.dasdware.fa.functions.FunctionExpressionCreator;
import de.dasdware.fa.program.FunctionBuilderRegister;
import de.dasdware.fa.program.Images;
import de.dasdware.fa.program.JOptionPanel;
import de.dasdware.fa.program.Messages;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JFunctionDialog
extends JDialog {
    private static final long serialVersionUID = -895018381478465096L;
    private JTextField name;
    private JTextField function;
    private JComboBox notation;
    private boolean success = false;
    private static Function lastFunction;

    public JFunctionDialog(JFrame owner, String title, final Function f) {
        super(owner, title, true);
        JOptionPanel jop = new JOptionPanel();
        this.name = new JTextField(f == null ? "" : f.getName());
        this.name.setPreferredSize(new Dimension(150, 20));
        jop.addOption(Messages.getString("JFunctionDialog.1"), this.name);
        this.function = new JTextField("");
        this.function.setPreferredSize(new Dimension(150, 20));
        jop.addOption(Messages.getString("JFunctionDialog.3"), this.function);
        this.notation = new JComboBox(FunctionBuilderRegister.createComboBoxModel());
        this.notation.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (f != null) {
                    FunctionBuilder fb = (FunctionBuilder)JFunctionDialog.this.notation.getSelectedItem();
                    FunctionExpressionCreator fec = fb.getExpressionCreator();
                    JFunctionDialog.this.function.setText(fec.createExpression(f));
                }
            }
        });
        this.notation.setSelectedIndex(0);
        jop.addOption(Messages.getString("JFunctionDialog.4"), this.notation);
        JButton ok = new JButton(Messages.getString("JFunctionDialog.5"), Images.loadIcon("icons/accept.png"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFunctionDialog.this.success = true;
                JFunctionDialog.this.setVisible(false);
            }
        });
        JButton cancel = new JButton(Messages.getString("JFunctionDialog.7"), Images.loadIcon("icons/cancel.png"));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                JFunctionDialog.this.success = false;
                JFunctionDialog.this.setVisible(false);
            }
        });
        JPanel btns = new JPanel(new FlowLayout(0, 0, 0));
        btns.add(ok);
        btns.add(cancel);
        jop.addOption("", btns);
        this.setLayout(new BorderLayout());
        this.add("Center", jop);
        this.pack();
        Rectangle r = this.getBounds();
        r.width += 10;
        this.setBounds(r);
        this.setResizable(false);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int top = (d.height - this.getHeight()) / 2;
        int left = (d.width - this.getWidth()) / 2;
        this.setBounds(new Rectangle(left, top, this.getWidth(), this.getHeight()));
    }

    public static boolean createFunction(JFrame owner, String title, Context context) {
        JFunctionDialog d = new JFunctionDialog(owner, title, null);
        d.setVisible(true);
        if (d.success) {
            try {
                FunctionBuilder fb = (FunctionBuilder)d.notation.getSelectedItem();
                lastFunction = fb.build(d.function.getText(), d.name.getText(), context);
            }
            catch (Exception e) {
                lastFunction = null;
                d.success = false;
            }
        }
        d.dispose();
        return d.success;
    }

    public static boolean editFunction(JFrame owner, String title, Function f, Context context) {
        JFunctionDialog d = new JFunctionDialog(owner, title, f);
        d.setVisible(true);
        if (d.success) {
            try {
                FunctionBuilder fb = (FunctionBuilder)d.notation.getSelectedItem();
                lastFunction = fb.build(d.function.getText(), d.name.getText(), context);
            }
            catch (Exception e) {
                lastFunction = null;
                d.success = false;
            }
        }
        d.dispose();
        return d.success;
    }

    public static Function getLastFunction() {
        return lastFunction;
    }
}

