/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.program;

import de.dasdware.fa.Standard;
import de.dasdware.fa.context.Context;
import de.dasdware.fa.context.ContextEvent;
import de.dasdware.fa.context.impl.ContextAdapter;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionPoint;
import de.dasdware.fa.program.Messages;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class JContextTable
extends JTable {
    private static final long serialVersionUID = 4129465000715597217L;
    private FunctionContextTableModel fctModel;
    private PointContextTableModel pctModel;

    public JContextTable(Context context, Type type) {
        if (type == Type.FUNCTIONS) {
            this.fctModel = new FunctionContextTableModel(context);
            this.setModel(this.fctModel);
        } else {
            this.pctModel = new PointContextTableModel(context);
            this.setModel(this.pctModel);
        }
        this.getSelectionModel().setSelectionMode(0);
        this.getColumnModel().getColumn(0).setMinWidth(16);
        this.getColumnModel().getColumn(0).setMaxWidth(16);
    }

    public Function getSelectedFunction() {
        if (this.fctModel != null) {
            return this.fctModel.getFunctionAt(this.getSelectedRow());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FunctionContextTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1489689883406530425L;
        private Context context;
        private Function[] functions;

        public FunctionContextTableModel(Context context) {
            this.context = context;
            this.functions = new Function[context.countFunctions()];
            Iterator<Function> itf = context.functionIterator();
            int i = 0;
            while (itf.hasNext()) {
                this.functions[i++] = itf.next();
            }
            context.addContextListener(new ContextAdapter(){

                public void functionExchanged(ContextEvent ce) {
                    Function fold = ce.getOldFunction();
                    Function fnew = ce.getFunction();
                    int i = 0;
                    while (i < FunctionContextTableModel.this.functions.length) {
                        if (FunctionContextTableModel.this.functions[i].equals(fold)) {
                            ((FunctionContextTableModel)FunctionContextTableModel.this).functions[i] = fnew;
                            FunctionContextTableModel.this.fireTableRowsUpdated(i, i);
                            return;
                        }
                        ++i;
                    }
                }

                public void functionAdded(ContextEvent ce) {
                    Function[] dest = new Function[FunctionContextTableModel.this.functions.length + 1];
                    System.arraycopy(FunctionContextTableModel.this.functions, 0, dest, 0, FunctionContextTableModel.this.functions.length);
                    dest[((FunctionContextTableModel)FunctionContextTableModel.this).functions.length] = ce.getFunction();
                    FunctionContextTableModel.this.functions = dest;
                    FunctionContextTableModel.this.fireTableRowsInserted(FunctionContextTableModel.this.functions.length - 1, FunctionContextTableModel.this.functions.length - 1);
                }

                public void functionRemoved(ContextEvent ce) {
                    Function[] dest = new Function[FunctionContextTableModel.this.functions.length - 1];
                    int pos = -1;
                    int i = 0;
                    int j = 0;
                    while (i < FunctionContextTableModel.this.functions.length) {
                        if (!FunctionContextTableModel.this.functions[i].equals(ce.getFunction())) {
                            dest[j++] = FunctionContextTableModel.this.functions[i];
                        } else {
                            pos = i;
                        }
                        ++i;
                    }
                    FunctionContextTableModel.this.functions = dest;
                    FunctionContextTableModel.this.fireTableRowsDeleted(pos, pos);
                }

                public void functionSelected(ContextEvent event) {
                    FunctionContextTableModel.this.fireTableCellUpdated(this.fToI(event.getFunction()), 0);
                }

                public void functionUnselected(ContextEvent event) {
                    FunctionContextTableModel.this.fireTableCellUpdated(this.fToI(event.getFunction()), 0);
                }

                private int fToI(Function f) {
                    int i = 0;
                    while (i < FunctionContextTableModel.this.functions.length) {
                        if (FunctionContextTableModel.this.functions[i].equals(f)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
            });
        }

        @Override
        public int getRowCount() {
            return this.functions.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return Messages.getString("JContextTable.1");
                }
                case 2: {
                    return Messages.getString("JContextTable.2");
                }
            }
            return super.getColumnName(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.context.functionSelected(this.functions[row]);
                }
                case 1: {
                    return this.functions[row].getName();
                }
                case 2: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if ((Boolean)aValue == Boolean.TRUE) {
                    this.context.selectFunction(this.functions[rowIndex]);
                } else {
                    this.context.unselectFunction(this.functions[rowIndex]);
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Function getFunctionAt(int row) {
            try {
                return this.functions[row];
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PointContextTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7986583581248085360L;
        private String[] headers = new String[]{"", Messages.getString("JContextTable.5"), Messages.getString("JContextTable.6"), Messages.getString("JContextTable.7"), Messages.getString("JContextTable.8")};
        private Context context;
        private FunctionPoint[] points;

        public PointContextTableModel(Context context) {
            this.context = context;
            this.points = new FunctionPoint[context.countPoints()];
            Iterator<FunctionPoint> itf = context.pointIterator();
            int i = 0;
            while (itf.hasNext()) {
                this.points[i++] = itf.next();
            }
            context.addContextListener(new ContextAdapter(){

                public void pointAdded(ContextEvent ce) {
                    FunctionPoint[] dest = new FunctionPoint[PointContextTableModel.this.points.length + 1];
                    System.arraycopy(PointContextTableModel.this.points, 0, dest, 0, PointContextTableModel.this.points.length);
                    dest[((PointContextTableModel)PointContextTableModel.this).points.length] = ce.getPoint();
                    PointContextTableModel.this.points = dest;
                    PointContextTableModel.this.fireTableRowsInserted(PointContextTableModel.this.points.length - 1, PointContextTableModel.this.points.length - 1);
                }

                public void pointRemoved(ContextEvent ce) {
                    FunctionPoint[] dest = new FunctionPoint[PointContextTableModel.this.points.length - 1];
                    int pos = -1;
                    int i = 0;
                    int j = 0;
                    while (i < PointContextTableModel.this.points.length) {
                        if (!PointContextTableModel.this.points[i].equals(ce.getPoint())) {
                            dest[j++] = PointContextTableModel.this.points[i];
                        } else {
                            pos = i;
                        }
                        ++i;
                    }
                    PointContextTableModel.this.points = dest;
                    PointContextTableModel.this.fireTableRowsDeleted(pos, pos);
                }

                public void functionSelected(ContextEvent ce) {
                    int i = 0;
                    while (i < PointContextTableModel.this.points.length) {
                        Function[] f = PointContextTableModel.this.points[i].getFunction();
                        int j = 0;
                        while (j < f.length) {
                            if (f[j].equals(ce.getFunction())) {
                                PointContextTableModel.this.fireTableCellUpdated(i, 0);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }

                public void functionUnselected(ContextEvent event) {
                    this.functionSelected(event);
                }
            });
        }

        protected void removePointsByFunction(Function f) {
            int c = 0;
            int i = 0;
            while (i < this.points.length) {
                if (this.points[i].getFunction().equals(f)) {
                    ++c;
                }
                ++i;
            }
            FunctionPoint[] dest = new FunctionPoint[this.points.length - c];
            int i2 = 0;
            int j = 0;
            while (i2 < this.points.length) {
                if (!this.points[i2].getFunction().equals(f)) {
                    dest[j++] = this.points[i2];
                }
                ++i2;
            }
            this.points = dest;
            this.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int column) {
            return this.headers[column];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.points.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            FunctionPoint p = this.points[row];
            Function[] f = p.getFunction();
            switch (col) {
                case 0: {
                    int i = 0;
                    while (i < f.length) {
                        if (this.context.functionSelected(f[i])) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                case 1: {
                    String s = "";
                    int i = 0;
                    while (i < f.length) {
                        if (i > 0) {
                            s = String.valueOf(s) + ", ";
                        }
                        s = String.valueOf(s) + f[i].getName();
                        ++i;
                    }
                    return s;
                }
                case 2: {
                    switch (p.getType()) {
                        case ROOT: {
                            return Messages.getString("JContextTable.11");
                        }
                        case TURNING: {
                            return Messages.getString("JContextTable.12");
                        }
                        case INFLECTION: {
                            return Messages.getString("JContextTable.13");
                        }
                        case INTERSECTION: {
                            return Messages.getString("JContextTable.14");
                        }
                    }
                    return "#ERR";
                }
                case 3: {
                    return Standard.formatNumber(p.getX());
                }
                case 4: {
                    return Standard.formatNumber(p.getY());
                }
            }
            return "#ERR";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FUNCTIONS,
        POINTS;

    }
}

