/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.plotter;

import de.dasdware.fa.Standard;
import de.dasdware.fa.context.Context;
import de.dasdware.fa.context.ContextEvent;
import de.dasdware.fa.context.ContextListener;
import de.dasdware.fa.context.impl.DemuxContextAdapter;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JPanel;

public class JPlotter
extends JPanel {
    private static final long serialVersionUID = -6589933927013909127L;
    private boolean haveFocus;
    private int trackMode;
    private Point mousePos = null;
    private Context context;
    private ContextListener contextListener = new DemuxContextAdapter(){

        public void notify(ContextEvent ce) {
            JPlotter.this.repaint();
        }
    };
    private MouseAdvListener moveListener = new MouseAdvListener(){
        private boolean down = false;
        private Cursor normalCursor;
        private Cursor moveCursor;
        private Point lastPos;
        {
            this.normalCursor = JPlotter.this.getCursor();
            this.moveCursor = new Cursor(13);
            this.lastPos = null;
        }

        public void mouseClicked(MouseEvent e) {
            JPlotter.this.setCursor(this.normalCursor);
            this.down = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.down = true;
            JPlotter.this.setCursor(this.moveCursor);
            this.lastPos = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            this.down = false;
            JPlotter.this.setCursor(this.normalCursor);
        }

        public void mouseDragged(MouseEvent e) {
            if (this.down) {
                Point p = e.getPoint();
                int dx = p.x - this.lastPos.x;
                int dy = p.y - this.lastPos.y;
                double ddx = -((JPlotter.this.context.getXMax() - JPlotter.this.context.getXMin()) / (double)JPlotter.this.getWidth()) * (double)dx;
                double ddy = (JPlotter.this.context.getYMax() - JPlotter.this.context.getYMin()) / (double)JPlotter.this.getHeight() * (double)dy;
                JPlotter.this.context.move(ddx, ddy);
                this.lastPos = p;
                JPlotter.this.mousePos = null;
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseWheelMoved(MouseWheelEvent mwe) {
            JPlotter.this.context.zoomRelative(1.0 - 0.04 * (double)mwe.getWheelRotation());
        }
    };
    public static final int TRACK_NONE = 0;
    public static final int TRACK_FREE = 1;
    public static final int TRACK_FUNC = 2;
    public static final String PROPERTY_TRACKMODE = "JPlotter:property:trackmode";
    public static final String PROPERTY_PLOTTERMODEL = "JPlotter:property:plottermodel";
    public static final String PROPERTY_CONTEXT = "JPlotter:property:context";

    public JPlotter(Context c) {
        this.context = c;
        this.setTrackMode(0);
        this.context.addContextListener(this.contextListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                JPlotter.this.haveFocus = true;
                JPlotter.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                JPlotter.this.haveFocus = false;
                JPlotter.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                JPlotter.this.mousePos = e.getPoint();
                JPlotter.this.repaint();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                JPlotter.this.mousePos = null;
                JPlotter.this.repaint();
            }
        });
        this.addMouseListener(this.moveListener);
        this.addMouseMotionListener(this.moveListener);
        this.addMouseWheelListener(this.moveListener);
    }

    public void setTrackMode(int mode) {
        int oldMode = this.trackMode;
        this.trackMode = mode;
        this.firePropertyChange(PROPERTY_TRACKMODE, oldMode, this.trackMode);
        this.repaint();
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context c) {
        Context old = this.context;
        old.removeContextListener(this.contextListener);
        this.context = c;
        this.context.addContextListener(this.contextListener);
        this.firePropertyChange(PROPERTY_CONTEXT, old, this.context);
        this.repaint();
    }

    public Point2D.Double getMousePos() {
        return this.absoluteToRelative(this.mousePos);
    }

    public void paint(Graphics g) {
        int y;
        int x;
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldat = g2d.getTransform();
        Iterator<Function> itf = null;
        Iterator<FunctionPoint> itp = null;
        Function f = null;
        FunctionPoint p = null;
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        double step = this.context.getPlotStep();
        double sclY = (double)this.getHeight() / (this.context.getYMax() - this.context.getYMin());
        double sclX = (double)this.getWidth() / (this.context.getXMax() - this.context.getXMin());
        double offX = (int)(sclX * -this.context.getXMin());
        double offY = (int)(sclY * -this.context.getYMin());
        g2d.transform(new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)this.getHeight()));
        g2d.transform(new AffineTransform(1.0, 0.0, 0.0, 1.0, offX, offY));
        g2d.setColor(new Color(0, 0, 0));
        g2d.drawLine((int)(this.context.getXMin() * sclX), 0, (int)(this.context.getXMax() * sclX), 0);
        int c = 0;
        double pos = 0.0;
        while (pos < this.context.getXMax()) {
            x = (int)(pos * sclX);
            if (c++ % 10 != 0 || c == 1) {
                g2d.drawLine(x, -5, x, 5);
            } else {
                g2d.drawLine(x, -10, x, 10);
                g2d.drawLine(x + 1, -10, x + 1, 10);
            }
            pos += this.context.getXScl();
        }
        c = 0;
        pos = 0.0;
        while (pos > this.context.getXMin()) {
            x = (int)(pos * sclX);
            if (c++ % 10 != 0 || c == 1) {
                g2d.drawLine(x, -5, x, 5);
            } else {
                g2d.drawLine(x, -10, x, 10);
                g2d.drawLine(x + 1, -10, x + 1, 10);
            }
            pos -= this.context.getXScl();
        }
        g2d.drawLine(0, (int)(this.context.getYMin() * sclY), 0, (int)(this.context.getYMax() * sclY));
        c = 0;
        pos = 0.0;
        while (pos < this.context.getYMax()) {
            y = (int)(pos * sclY);
            if (c++ % 10 != 0 || c == 1) {
                g2d.drawLine(-5, y, 5, y);
            } else {
                g2d.drawLine(-10, y, 10, y);
                g2d.drawLine(-10, y + 1, 10, y + 1);
            }
            pos += this.context.getYScl();
        }
        c = 0;
        pos = 0.0;
        while (pos > this.context.getYMin()) {
            y = (int)(pos * sclY);
            if (c++ % 10 != 0 || c == 1) {
                g2d.drawLine(-5, y, 5, y);
            } else {
                g2d.drawLine(-10, y, 10, y);
                g2d.drawLine(-10, y + 1, 10, y + 1);
            }
            pos -= this.context.getYScl();
        }
        itf = this.context.functionIterator();
        while (itf.hasNext()) {
            f = itf.next();
            if (this.context.functionSelected(f)) {
                g2d.setStroke(new BasicStroke(3.0f));
            } else {
                g2d.setStroke(new BasicStroke(1.0f));
            }
            this.simplePlot(g2d, f, step, sclX, sclY);
        }
        g2d.setColor(new Color(0, 125, 0));
        g2d.setStroke(new BasicStroke(2.0f));
        itp = this.context.pointIterator();
        while (itp.hasNext()) {
            p = itp.next();
            this.simplePoint(g2d, p, sclX, sclY);
        }
        if (this.haveFocus) {
            g2d.setTransform(oldat);
            g2d.setColor(new Color(0, 0, 127));
            g2d.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{5.0f, 7.0f}, 1.0f));
            g2d.drawRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
            if ((this.trackMode == 1 || this.trackMode == 2) && this.mousePos != null) {
                Point2D.Double mrp = this.absoluteToRelative(this.mousePos);
                if (this.trackMode == 2) {
                    double dist = Double.POSITIVE_INFINITY;
                    Function f0 = null;
                    itf = this.context.functionIterator();
                    while (itf.hasNext()) {
                        try {
                            double ndist = Math.abs(f.getValueAt(mrp.x, this.context) - mrp.y);
                            if (ndist < dist) {
                                dist = ndist;
                                f0 = f;
                                mrp.y = f.getValueAt(mrp.x, this.context);
                            }
                        }
                        catch (DomainException ndist) {
                            // empty catch block
                        }
                        f = itf.next();
                    }
                    if (f0 != null) {
                        this.mousePos = this.relativeToAbsolute(mrp);
                    }
                }
                g2d.setStroke(new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{6.0f, 3.0f}, 1.0f));
                g2d.setColor(new Color(127, 127, 127));
                g2d.drawLine(0, this.mousePos.y, this.getWidth(), this.mousePos.y);
                g2d.drawLine(this.mousePos.x, 0, this.mousePos.x, this.getHeight());
                mrp = this.absoluteToRelative(this.mousePos);
                String output = "(" + Standard.formatNumber(mrp.x) + "; " + Standard.formatNumber(mrp.y) + ")";
                int w = g2d.getFontMetrics().charsWidth(output.toCharArray(), 0, output.length());
                int h = (int)g2d.getFont().getLineMetrics(output, 0, output.length(), g2d.getFontRenderContext()).getHeight();
                int ox = 0;
                int oy = 0;
                ox = this.mousePos.x < this.getWidth() - w - 8 ? this.mousePos.x + 4 : this.mousePos.x - 4 - w;
                oy = this.mousePos.y > h + 8 ? this.mousePos.y - 4 : this.mousePos.y + h;
                g2d.drawString(output, ox, oy);
            }
        }
    }

    private void simplePlot(Graphics2D g2d, Function f, double step, double sclX, double sclY) {
        int y1;
        g2d.setColor(new Color(255, 0, 0));
        double from = 0.0;
        double to = 0.0;
        try {
            from = Math.max(this.context.getXMin(), f.getDomain(this.context).getMinimumValue(this.context));
            to = Math.min(this.context.getXMax(), f.getDomain(this.context).getMaximumValue(this.context));
        }
        catch (DomainException e) {
            return;
        }
        int x1 = (int)(from * sclX);
        try {
            y1 = (int)(f.getValueAt(from, this.context) * sclY);
        }
        catch (DomainException de) {
            System.out.println(de);
            y1 = 0;
        }
        int x2 = 0;
        int y2 = 0;
        double pos = from + step;
        while (pos < to + step) {
            x2 = (int)(pos * sclX);
            try {
                y2 = (int)(f.getValueAt(pos, this.context) * sclY);
            }
            catch (DomainException de) {
                System.out.println(de);
                y2 = 0;
            }
            g2d.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
            pos += step;
        }
    }

    private void simplePoint(Graphics2D g2d, FunctionPoint p, double sclX, double sclY) {
        int x0 = (int)(p.getX() * sclX);
        int y0 = (int)(p.getY() * sclY);
        g2d.drawOval(x0 - 7, y0 - 7, 15, 15);
        g2d.drawOval(x0 - 2, y0 - 2, 5, 5);
    }

    private Point2D.Double absoluteToRelative(Point p) {
        return new Point2D.Double(1.0 * (double)p.x / (double)this.getWidth() * (this.context.getXMax() - this.context.getXMin()) + this.context.getXMin(), ((double)this.getHeight() * 1.0 - (double)p.y) / (double)this.getHeight() * (this.context.getYMax() - this.context.getYMin()) + this.context.getYMin());
    }

    private Point relativeToAbsolute(Point2D.Double p) {
        return new Point((int)((p.x - this.context.getXMin()) / (this.context.getXMax() - this.context.getXMin()) * (double)this.getWidth()), (int)((double)this.getHeight() * (1.0 - (p.y - this.context.getYMin()) / (this.context.getYMax() - this.context.getYMin()))));
    }

    private static interface MouseAdvListener
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
    }
}

