/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.plotter;

import de.dasdware.fa.Standard;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionVisitor;
import de.dasdware.fa.functions.impl.ConstantFunction;
import de.dasdware.fa.functions.impl.DerivatingFunction;
import de.dasdware.fa.functions.impl.IdentityFunction;
import de.dasdware.fa.functions.impl.IntegratingFunction;
import de.dasdware.fa.functions.impl.SimpleOperationFunction;
import de.dasdware.fa.functions.impl.VariableFunction;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class JFunctionTreeDrawer
extends JPanel {
    private static final long serialVersionUID = -4780344385225835832L;
    private Image result;

    public JFunctionTreeDrawer(Function f) {
        this.result = f.acceptVisitor(new Drawer());
    }

    public void paint(Graphics g) {
        if (this.result != null) {
            g.drawImage(this.result, 0, 0, this.result.getWidth(this), this.result.getHeight(this), this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Drawer
    implements FunctionVisitor<Image> {
        private Drawer() {
        }

        protected int textWidth(Graphics g2d, String output) {
            return g2d.getFontMetrics().charsWidth(output.toCharArray(), 0, output.length());
        }

        @Override
        public Image visit(ConstantFunction f) {
            BufferedImage img = new BufferedImage(60, 30, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(227, 227, 227));
            g.fillRect(0, 0, 60, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawRect(0, 0, 59, 29);
            String out = Standard.formatNumber(f.getConstantValue());
            int ow = this.textWidth(g, out);
            g.drawString(out, 30 - ow / 2, 19);
            return img;
        }

        @Override
        public Image visit(IdentityFunction f) {
            BufferedImage img = new BufferedImage(60, 30, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(227, 255, 255));
            g.fillRect(0, 0, 60, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawRect(0, 0, 59, 29);
            String out = "x";
            int ow = this.textWidth(g, out);
            g.drawString(out, 30 - ow / 2, 19);
            return img;
        }

        @Override
        public Image visit(VariableFunction f) {
            BufferedImage img = new BufferedImage(60, 30, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(255, 227, 255));
            g.fillRect(0, 0, 60, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawRect(0, 0, 59, 29);
            String out = f.getVariableName();
            int ow = this.textWidth(g, out);
            g.drawString(out, 30 - ow / 2, 19);
            return img;
        }

        @Override
        public Image visit(SimpleOperationFunction f) {
            Image left = f.getFunction1().acceptVisitor(this);
            Image right = f.getFunction2().acceptVisitor(this);
            int lw = left.getWidth(JFunctionTreeDrawer.this);
            int lh = left.getHeight(JFunctionTreeDrawer.this);
            int rw = right.getWidth(JFunctionTreeDrawer.this);
            int rh = right.getHeight(JFunctionTreeDrawer.this);
            int w = lw + rw + 10;
            int h = Math.max(lh, rh) + 60;
            BufferedImage img = new BufferedImage(w, h, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, w, h);
            g.drawImage(left, 0, 60, JFunctionTreeDrawer.this);
            g.drawImage(right, lw + 10, 60, JFunctionTreeDrawer.this);
            g.setColor(new Color(0, 0, 0));
            g.drawLine(lw / 2, 60, w / 2, 13);
            g.drawLine(lw + 10 + rw / 2, 60, w / 2, 13);
            g.setColor(new Color(255, 255, 255));
            g.fillOval(w / 2 - 15, 0, 30, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawOval(w / 2 - 15, 0, 30, 30);
            String out = "#";
            switch (f.getType()) {
                case ADD: {
                    out = "+";
                    break;
                }
                case SUBTRACT: {
                    out = "-";
                    break;
                }
                case MULTIPLY: {
                    out = "*";
                    break;
                }
                case DIVIDE: {
                    out = "/";
                    break;
                }
                case POWER: {
                    out = "^";
                }
            }
            int ow = this.textWidth(g, out);
            g.drawString(out, (w - ow) / 2, 19);
            return img;
        }

        @Override
        public Image visit(DerivatingFunction f) {
            Image orig = f.getDerivated().acceptVisitor(this);
            int ow = orig.getWidth(JFunctionTreeDrawer.this);
            int oh = orig.getHeight(JFunctionTreeDrawer.this);
            int w = ow;
            int h = oh + 60;
            BufferedImage img = new BufferedImage(w, h, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, w, h);
            g.drawImage(orig, 0, 60, JFunctionTreeDrawer.this);
            g.setColor(new Color(0, 0, 0));
            g.drawLine(ow / 2, 60, w / 2, 13);
            g.setColor(new Color(255, 255, 255));
            g.fillOval(w / 2 - 15, 0, 30, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawOval(w / 2 - 15, 0, 30, 30);
            String out = "der";
            int osw = this.textWidth(g, out);
            g.drawString(out, (w - osw) / 2, 19);
            return img;
        }

        @Override
        public Image visit(IntegratingFunction f) {
            Image orig = f.getIntegrated().acceptVisitor(this);
            int ow = orig.getWidth(JFunctionTreeDrawer.this);
            int oh = orig.getHeight(JFunctionTreeDrawer.this);
            int w = ow;
            int h = oh + 60;
            BufferedImage img = new BufferedImage(w, h, 5);
            Graphics g = ((Image)img).getGraphics();
            g.setColor(new Color(255, 255, 255));
            g.fillRect(0, 0, w, h);
            g.drawImage(orig, 0, 60, JFunctionTreeDrawer.this);
            g.setColor(new Color(0, 0, 0));
            g.drawLine(ow / 2, 60, w / 2, 13);
            g.setColor(new Color(255, 255, 255));
            g.fillOval(w / 2 - 15, 0, 30, 30);
            g.setColor(new Color(0, 0, 0));
            g.drawOval(w / 2 - 15, 0, 30, 30);
            String out = "int";
            int osw = this.textWidth(g, out);
            g.drawString(out, (w - osw) / 2, 19);
            return img;
        }
    }
}

