/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionFactory;
import de.dasdware.fa.functions.impl.ConstantFunction;
import de.dasdware.fa.functions.impl.DerivatingFunction;
import de.dasdware.fa.functions.impl.IdentityFunction;
import de.dasdware.fa.functions.impl.IntegratingFunction;
import de.dasdware.fa.functions.impl.SimpleOperationFunction;
import de.dasdware.fa.functions.impl.VariableFunction;

public class StandardFunctionFactory
implements FunctionFactory {
    public Function createIdentity() {
        return new IdentityFunction();
    }

    public Function createConstant(double constant) {
        return new ConstantFunction(constant);
    }

    public Function createSum(Function f1, Function f2) {
        return new SimpleOperationFunction(SimpleOperationFunction.Type.ADD, f1, f2);
    }

    public Function createDifference(Function f1, Function f2) {
        return new SimpleOperationFunction(SimpleOperationFunction.Type.SUBTRACT, f1, f2);
    }

    public Function createProduct(Function f1, Function f2) {
        return new SimpleOperationFunction(SimpleOperationFunction.Type.MULTIPLY, f1, f2);
    }

    public Function createPower(Function base, Function exponent) {
        return new SimpleOperationFunction(SimpleOperationFunction.Type.POWER, base, exponent);
    }

    public Function createQuotient(Function f1, Function f2) {
        return new SimpleOperationFunction(SimpleOperationFunction.Type.DIVIDE, f1, f2);
    }

    public Function createDerivation(Function f) {
        return new DerivatingFunction(f);
    }

    public Function createIntegral(Function f) {
        return new IntegratingFunction(f);
    }

    public Function createVariableFunction(String name) {
        return new VariableFunction(name);
    }
}

