/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionVisitor;
import de.dasdware.fa.functions.impl.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleOperationFunction
extends AbstractFunction {
    private Type type;
    private Function function1;
    private Function function2;
    private Domain domain;

    public SimpleOperationFunction(Type type, Function function1, Function function2) {
        this.type = type;
        this.function1 = function1;
        this.function2 = function2;
    }

    @Override
    public Domain getDomain(Context c) throws DomainException {
        if (this.domain == null) {
            this.domain = this.function1.getDomain(c);
        }
        return this.domain;
    }

    @Override
    public double getValueAt(double x, Context c) throws DomainException {
        this.getDomain(c).testValue(x, c);
        double v1 = this.function1.getValueAt(x, c);
        double v2 = this.function2.getValueAt(x, c);
        switch (this.type) {
            case ADD: {
                return v1 + v2;
            }
            case SUBTRACT: {
                return v1 - v2;
            }
            case MULTIPLY: {
                return v1 * v2;
            }
            case DIVIDE: {
                return v1 / v2;
            }
            case POWER: {
                return Math.pow(v1, v2);
            }
        }
        return 0.0;
    }

    public Function getFunction1() {
        return this.function1;
    }

    public Function getFunction2() {
        return this.function2;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <T> T acceptVisitor(FunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        POWER;

    }
}

