/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;

public class RangeDomain
implements Domain {
    private double min;
    private double max;
    private RangeConstraint upper;
    private RangeConstraint lower;

    public RangeDomain(double min, RangeConstraint lower, double max, RangeConstraint upper) {
        this.min = min;
        this.lower = lower;
        this.max = max;
        this.upper = upper;
    }

    public RangeDomain(double min, double max) {
        this(min, RangeConstraint.INCLUSIVE, max, RangeConstraint.INCLUSIVE);
    }

    public double getMaximumValue(Context fac) {
        if (this.upper == RangeConstraint.EXCLUSIVE) {
            return this.max - fac.getPlotStep();
        }
        return this.max;
    }

    public double getMinimumValue(Context fac) {
        if (this.lower == RangeConstraint.EXCLUSIVE) {
            return this.min + fac.getPlotStep();
        }
        return this.min;
    }

    public void testValue(double x, Context fac) throws DomainException {
        if (x < this.getMinimumValue(fac) || x > this.getMaximumValue(fac)) {
            throw new DomainException("Value " + x + "is not contained in this domain.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeConstraint {
        INCLUSIVE,
        EXCLUSIVE;

    }
}

