/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionBuilder;
import de.dasdware.fa.functions.FunctionExpressionCreator;
import de.dasdware.fa.functions.FunctionFactory;
import de.dasdware.fa.functions.impl.ConstantFunction;
import de.dasdware.fa.functions.impl.DerivatingFunction;
import de.dasdware.fa.functions.impl.IdentityFunction;
import de.dasdware.fa.functions.impl.IntegratingFunction;
import de.dasdware.fa.functions.impl.SimpleOperationFunction;
import de.dasdware.fa.functions.impl.VariableFunction;
import java.util.StringTokenizer;

public class PolishNotationBuilder
implements FunctionBuilder {
    private FunctionFactory factory;

    public PolishNotationBuilder(FunctionFactory f) {
        this.factory = f;
    }

    public String getNotationName() {
        return "Polish Notation (prefix)";
    }

    public Function build(String formula, String name, Context ctx) {
        Function f = this.build(formula, ctx);
        f.setName(name);
        return f;
    }

    public Function build(String formula, Context ctx) {
        return this.build0(new StringTokenizer(formula), ctx);
    }

    private Function build0(StringTokenizer tokens, Context ctx) {
        if (!tokens.hasMoreTokens()) {
            throw new RuntimeException("Expected another token although there is none. Probably syntax error in input string.");
        }
        String token = tokens.nextToken();
        if (token.matches("[+-]?[0-9]+(\\.[0-9]+)?([eE][+-]?[0-9]+)?")) {
            return this.factory.createConstant(Double.valueOf(token));
        }
        if (token.equals("x")) {
            return this.factory.createIdentity();
        }
        if (token.equals("e")) {
            return this.factory.createConstant(Math.E);
        }
        if (token.equals("pi")) {
            return this.factory.createConstant(Math.PI);
        }
        if (token.equals("der")) {
            Function f = this.build0(tokens, ctx);
            return this.factory.createDerivation(f);
        }
        if (token.equals("int")) {
            Function f = this.build0(tokens, ctx);
            return this.factory.createIntegral(f);
        }
        if (token.equals("^")) {
            Function b = this.build0(tokens, ctx);
            Function e = this.build0(tokens, ctx);
            return this.factory.createPower(b, e);
        }
        if (token.matches("[\\+\\-\\*/]")) {
            Function f1 = this.build0(tokens, ctx);
            Function f2 = this.build0(tokens, ctx);
            if (token.equals("+")) {
                return this.factory.createSum(f1, f2);
            }
            if (token.equals("-")) {
                return this.factory.createDifference(f1, f2);
            }
            if (token.equals("*")) {
                return this.factory.createProduct(f1, f2);
            }
            if (token.equals("/")) {
                return this.factory.createQuotient(f1, f2);
            }
        }
        if (ctx.getFunction(token) != null) {
            return this.factory.createVariableFunction(token);
        }
        throw new RuntimeException("Cannot handle token '" + token + "'.");
    }

    public String toString() {
        return this.getNotationName();
    }

    public FunctionExpressionCreator getExpressionCreator() {
        return new FunctionExpressionCreator(){

            public String visit(ConstantFunction f) {
                return "" + f.getConstantValue();
            }

            public String visit(IdentityFunction f) {
                return "x";
            }

            public String visit(SimpleOperationFunction f) {
                String t = "";
                switch (f.getType()) {
                    case ADD: {
                        t = "+ ";
                        break;
                    }
                    case SUBTRACT: {
                        t = "- ";
                        break;
                    }
                    case MULTIPLY: {
                        t = "* ";
                        break;
                    }
                    case DIVIDE: {
                        t = "/ ";
                        break;
                    }
                    case POWER: {
                        t = "^ ";
                    }
                }
                return String.valueOf(t) + f.getFunction1().acceptVisitor(this) + " " + f.getFunction2().acceptVisitor(this);
            }

            public String visit(DerivatingFunction f) {
                return "der " + f.getDerivated().acceptVisitor(this);
            }

            public String visit(IntegratingFunction f) {
                return "int " + f.getIntegrated().acceptVisitor(this);
            }

            public String visit(VariableFunction f) {
                return f.getVariableName();
            }
        };
    }
}

