/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Analyzer;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionFactory;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewtonFunctionAnalyzer
implements Analyzer {
    private FunctionFactory factory;
    public static final int MAX_ITERATIONS = 1000;

    public NewtonFunctionAnalyzer(FunctionFactory factory) {
        this.factory = factory;
    }

    private Function createNewtonFunction(Function f) {
        Function f0 = this.factory.createDifference(this.factory.createIdentity(), this.factory.createQuotient(f, this.factory.createDerivation(f)));
        return f0;
    }

    @Override
    public double[] analyzeIntersections(Function[] f, Context c) {
        if (f.length < 2) {
            return null;
        }
        Function diff = this.factory.createDifference(f[0], f[1]);
        List<Double> candidates = this.internalAnalyzeRoots(diff, c);
        Iterator<Double> it = candidates.iterator();
        block2: while (it.hasNext()) {
            try {
                double x = it.next();
                double y = f[0].getValueAt(x, c);
                int i = 1;
                while (i < f.length) {
                    if (!c.isEqual(y, f[i].getValueAt(x, c))) {
                        it.remove();
                        continue block2;
                    }
                    ++i;
                }
            }
            catch (DomainException de) {
                it.remove();
            }
        }
        return this.listToArray(candidates);
    }

    @Override
    public double[] analyzeInflections(Function f, Context c) {
        Function der2 = this.factory.createDerivation(this.factory.createDerivation(f));
        Function der3 = this.factory.createDerivation(der2);
        List<Double> candidates = this.internalAnalyzeRoots(der2, c);
        Iterator<Double> it = candidates.iterator();
        while (it.hasNext()) {
            try {
                if (!c.isEqual(der3.getValueAt(it.next(), c), 0.0)) continue;
                it.remove();
            }
            catch (DomainException e) {
                it.remove();
            }
        }
        return this.listToArray(candidates);
    }

    @Override
    public double[] analyzeTurnings(Function f, Context c) {
        Function der1 = this.factory.createDerivation(f);
        Function der2 = this.factory.createDerivation(der1);
        List<Double> candidates = this.internalAnalyzeRoots(der1, c);
        Iterator<Double> it = candidates.iterator();
        while (it.hasNext()) {
            try {
                if (!c.isEqual(der2.getValueAt(it.next(), c), 0.0)) continue;
                it.remove();
            }
            catch (DomainException e) {
                it.remove();
            }
        }
        return this.listToArray(candidates);
    }

    @Override
    public double[] analyzeRoots(Function f, Context c) {
        return this.listToArray(this.internalAnalyzeRoots(f, c));
    }

    protected List<Double> internalAnalyzeRoots(Function f, Context c) {
        Domain d;
        Function testf = this.createNewtonFunction(f);
        LinkedList<Double> roots = new LinkedList<Double>();
        try {
            d = f.getDomain(c);
        }
        catch (DomainException e1) {
            return roots;
        }
        double min = Math.max(c.getXMin(), d.getMinimumValue(c));
        double max = Math.min(c.getXMax(), d.getMaximumValue(c));
        double stp = c.getXScl() / 2.0;
        double lastRoot = Double.POSITIVE_INFINITY;
        double x = 0.0;
        x = min;
        while (x < max) {
            double xn = Double.POSITIVE_INFINITY;
            double root = x;
            int it = 0;
            while (!c.isEqual(root, xn) && it < 1000 && root != Double.NEGATIVE_INFINITY && root != Double.POSITIVE_INFINITY) {
                xn = root;
                try {
                    root = testf.getValueAt(xn, c);
                }
                catch (DomainException e) {
                    it = 1000;
                    break;
                }
                ++it;
            }
            if (it < 1000) {
                if (lastRoot == Double.POSITIVE_INFINITY) {
                    lastRoot = root + c.getPrecision() + 1.0;
                }
                if (!c.isEqual(lastRoot, root)) {
                    roots.add(root);
                    lastRoot = root;
                }
            }
            x += stp;
        }
        return roots;
    }

    private double[] listToArray(List<Double> list) {
        double[] ret = new double[list.size()];
        int i = 0;
        for (double r : list) {
            ret[i++] = r;
        }
        return ret;
    }
}

