/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionVisitor;
import de.dasdware.fa.functions.impl.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegratingFunction
extends AbstractFunction {
    private double lastX = Double.NEGATIVE_INFINITY;
    private double lastY = Double.NEGATIVE_INFINITY;
    private Function integrated;

    public IntegratingFunction(Function integrated) {
        this.integrated = integrated;
    }

    @Override
    public Domain getDomain(Context c) throws DomainException {
        return this.integrated.getDomain(c);
    }

    @Override
    public double getValueAt(double x, Context c) throws DomainException {
        double dx = c.getPlotStep();
        double y = 0.0;
        if (c.isEqual(x, this.lastX + dx)) {
            double cur = dx * this.integrated.getValueAt(x, c);
            y = this.lastY + cur;
        } else {
            double d = 0.0;
            while (d <= x) {
                y += this.integrated.getValueAt(d, c) * dx;
                d += dx;
            }
            d = 0.0;
            while (d >= x) {
                y -= this.integrated.getValueAt(d, c) * dx;
                d -= dx;
            }
        }
        this.lastX = x;
        this.lastY = y;
        return y;
    }

    public Function getIntegrated() {
        return this.integrated;
    }

    @Override
    public <T> T acceptVisitor(FunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

