/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.impl.DomainDecorator;

public class DiscreteDomainRemover
extends DomainDecorator {
    private double[] removedValues;

    public DiscreteDomainRemover(Domain decorated, double[] removedValues) {
        super(decorated);
        this.removedValues = removedValues;
    }

    public void testValue(double x, Context fac) throws DomainException {
        super.testValue(x, fac);
        int i = 0;
        while (i < this.removedValues.length) {
            if (Math.abs(this.removedValues[i] - x) < fac.getPrecision()) {
                throw new DomainException("Value " + x + " is not permitted within this domain.");
            }
            ++i;
        }
    }
}

