/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.functions.Domain;
import de.dasdware.fa.functions.DomainException;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionVisitor;
import de.dasdware.fa.functions.impl.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivatingFunction
extends AbstractFunction {
    private Function derivated;

    public DerivatingFunction(Function derivated) {
        this.derivated = derivated;
    }

    @Override
    public Domain getDomain(Context c) throws DomainException {
        return this.derivated.getDomain(c);
    }

    @Override
    public double getValueAt(double x, Context c) throws DomainException {
        double dx = c.getPlotStep();
        double dy = this.derivated.getValueAt(x + dx / 2.0, c) - this.derivated.getValueAt(x - dx / 2.0, c);
        return dy / dx;
    }

    @Override
    public <T> T acceptVisitor(FunctionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public Function getDerivated() {
        return this.derivated;
    }
}

