/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.functions.impl;

import de.dasdware.fa.context.Context;
import de.dasdware.fa.context.ContextEvent;
import de.dasdware.fa.context.impl.ContextAdapter;
import de.dasdware.fa.functions.Analyzer;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.impl.AnalyzerDecorator;
import java.util.HashMap;
import java.util.Map;

public class CachedAnalyzer
extends AnalyzerDecorator {
    private Map<Function, double[]> roots = null;
    private Map<Function, double[]> turnings = null;
    private Map<Function, double[]> inflections = null;

    public CachedAnalyzer(Analyzer decorated, Context context) {
        super(decorated);
        context.addContextListener(new ContextAdapter(){

            public void functionRemoved(ContextEvent ce) {
                CachedAnalyzer.this.clearFromCache(ce.getFunction());
            }

            public void functionExchanged(ContextEvent ce) {
                CachedAnalyzer.this.clearFromCache(ce.getFunction());
            }
        });
    }

    public double[] analyzeRoots(Function f, Context c) {
        if (this.roots == null) {
            this.roots = new HashMap<Function, double[]>();
            double[] r = super.analyzeRoots(f, c);
            this.roots.put(f, r);
            return r;
        }
        double[] r = this.roots.get(f);
        if (r == null) {
            r = super.analyzeRoots(f, c);
            this.roots.put(f, r);
        }
        return r;
    }

    public double[] analyzeTurnings(Function f, Context c) {
        if (this.turnings == null) {
            this.turnings = new HashMap<Function, double[]>();
            double[] r = super.analyzeTurnings(f, c);
            this.turnings.put(f, r);
            return r;
        }
        double[] r = this.turnings.get(f);
        if (r == null) {
            r = super.analyzeTurnings(f, c);
            this.turnings.put(f, r);
        }
        return r;
    }

    public double[] analyzeInflections(Function f, Context c) {
        if (this.inflections == null) {
            this.inflections = new HashMap<Function, double[]>();
            double[] r = super.analyzeInflections(f, c);
            this.inflections.put(f, r);
            return r;
        }
        double[] r = this.inflections.get(f);
        if (r == null) {
            r = super.analyzeInflections(f, c);
            this.inflections.put(f, r);
        }
        return r;
    }

    public void clearFromCache(Function f) {
        if (this.roots != null) {
            this.roots.remove(f);
        }
        if (this.turnings != null) {
            this.turnings.remove(f);
        }
        if (this.inflections != null) {
            this.inflections.remove(f);
        }
    }
}

