/*
 * Decompiled with CFR 0.152.
 */
package de.dasdware.fa.context.impl;

import de.dasdware.fa.Standard;
import de.dasdware.fa.context.Context;
import de.dasdware.fa.context.ContextEvent;
import de.dasdware.fa.context.ContextListener;
import de.dasdware.fa.functions.Analyzer;
import de.dasdware.fa.functions.Function;
import de.dasdware.fa.functions.FunctionPoint;
import de.dasdware.fa.functions.FunctionPointType;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextImpl
implements Context {
    private double xm;
    private double xr;
    private double xscl;
    private double ym;
    private double yr;
    private double yscl;
    private double zoomFactor;
    private List<Function> selectedFunctions;
    private List<ContextListener> listeners = new LinkedList<ContextListener>();
    private List<Function> functions = new LinkedList<Function>();
    private List<FunctionPoint> points;
    private Analyzer analyzer;
    private double plotStep;
    private double precision;
    private boolean intelliZoom;

    public ContextImpl(double xmin, double xmax, double xscl, double ymin, double ymax, double yscl, double plotstep, double precision) {
        this.selectedFunctions = new LinkedList<Function>();
        this.points = new LinkedList<FunctionPoint>();
        this.plotStep = plotstep;
        this.precision = precision;
        this.xm = (xmin + xmax) / 2.0;
        this.xr = this.xm - xmin;
        this.xscl = xscl;
        this.ym = (ymin + ymax) / 2.0;
        this.yr = this.ym - ymin;
        this.yscl = yscl;
        this.zoomFactor = 1.0;
        this.intelliZoom = true;
    }

    @Override
    public void addContextListener(ContextListener cl) {
        this.listeners.add(cl);
    }

    @Override
    public void removeContextListener(ContextListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireFunctionAdded(Function f) {
        for (ContextListener l : this.listeners) {
            l.functionAdded(new ContextEvent((Object)this, f));
        }
    }

    protected void fireFunctionRemoved(Function f) {
        for (ContextListener l : this.listeners) {
            l.functionRemoved(new ContextEvent((Object)this, f));
        }
    }

    protected void fireFunctionExchanged(Function f1, Function f2) {
        for (ContextListener l : this.listeners) {
            l.functionExchanged(new ContextEvent(this, f2, f1));
        }
    }

    protected void fireFunctionSelected(Function f) {
        for (ContextListener l : this.listeners) {
            l.functionSelected(new ContextEvent((Object)this, f));
        }
    }

    protected void fireFunctionUnselected(Function f) {
        for (ContextListener l : this.listeners) {
            l.functionUnselected(new ContextEvent((Object)this, f));
        }
    }

    protected void firePointAdded(FunctionPoint p) {
        for (ContextListener l : this.listeners) {
            l.pointAdded(new ContextEvent((Object)this, p));
        }
    }

    protected void firePointRemoved(FunctionPoint p) {
        for (ContextListener l : this.listeners) {
            l.pointRemoved(new ContextEvent((Object)this, p));
        }
    }

    protected void firePlotStepChanged(double v) {
        for (ContextListener l : this.listeners) {
            l.plotStepChanged(new ContextEvent((Object)this, v));
        }
    }

    protected void firePrecisionChanged(double v) {
        for (ContextListener l : this.listeners) {
            l.precisionChanged(new ContextEvent((Object)this, v));
        }
    }

    protected void fireDisplayUpdated() {
        for (ContextListener l : this.listeners) {
            l.displayUpdated(new ContextEvent(this));
        }
    }

    @Override
    public void addFunction(Function f) {
        this.functions.add(f);
        this.fireFunctionAdded(f);
    }

    @Override
    public Function getFunction(String name) {
        for (Function f : this.functions) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public void exchangeFunction(Function f1, Function f2) {
        if (this.functionSelected(f1)) {
            this.selectedFunctions.remove(f1);
            this.selectedFunctions.add(f2);
        }
        int i = this.functions.indexOf(f1);
        this.functions.remove(f1);
        this.functions.add(i, f2);
        this.removePoints(f1, null);
        this.fireFunctionExchanged(f1, f2);
    }

    @Override
    public void removeFunction(Function f) {
        this.functions.remove(f);
        this.removePoints(f, null);
        this.fireFunctionRemoved(f);
    }

    @Override
    public void removeAllFunctions() {
        Iterator<Function> it = this.functionIterator();
        while (it.hasNext()) {
            Function f = it.next();
            it.remove();
            this.removePoints(f, null);
            this.fireFunctionRemoved(f);
        }
    }

    @Override
    public void removePoints(Function f, FunctionPointType type) {
        Iterator<FunctionPoint> it = this.pointIterator();
        block0: while (it.hasNext()) {
            FunctionPoint p = it.next();
            Function[] fa = p.getFunction();
            int i = 0;
            while (i < fa.length) {
                if (fa[i].equals(f) && (type == null || p.getType() == type)) {
                    it.remove();
                    this.firePointRemoved(p);
                    continue block0;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean functionSelected(Function f) {
        return this.selectedFunctions.contains(f);
    }

    @Override
    public void selectFunction(Function f) {
        if (this.functions.contains(f) && !this.selectedFunctions.contains(f)) {
            this.selectedFunctions.add(f);
            this.fireFunctionSelected(f);
        }
    }

    @Override
    public void unselectFunction(Function f) {
        if (this.functions.contains(f) && this.selectedFunctions.contains(f)) {
            this.selectedFunctions.remove(f);
            this.fireFunctionUnselected(f);
        }
    }

    @Override
    public int countFunctions() {
        return this.functions.size();
    }

    @Override
    public Iterator<Function> functionIterator() {
        return this.functions.iterator();
    }

    @Override
    public void addPoint(FunctionPoint p) {
        this.points.add(p);
        this.firePointAdded(p);
    }

    @Override
    public void removePoint(FunctionPoint p) {
        this.points.remove(p);
        this.firePointRemoved(p);
    }

    @Override
    public int countPoints() {
        return this.points.size();
    }

    @Override
    public Iterator<FunctionPoint> pointIterator() {
        return this.points.iterator();
    }

    @Override
    public Analyzer getAnalyzer() {
        if (this.analyzer == null) {
            this.analyzer = Standard.createAnalyzer();
        }
        return this.analyzer;
    }

    @Override
    public void setPrecision(double precision) {
        this.precision = precision;
        this.firePrecisionChanged(precision);
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void setPlotStep(double plotStep) {
        this.plotStep = plotStep;
        this.firePlotStepChanged(plotStep);
    }

    @Override
    public double getPlotStep() {
        return this.plotStep;
    }

    @Override
    public boolean isEqual(double d1, double d2) {
        return Math.abs(d1 - d2) < this.precision;
    }

    @Override
    public void move(double dx, double dy) {
        this.move0(dx, dy);
        this.fireDisplayUpdated();
    }

    @Override
    public void moveToCenter() {
        this.xm = 0.0;
        this.ym = 0.0;
        this.fireDisplayUpdated();
    }

    private void move0(double dx, double dy) {
        this.xm += dx;
        this.ym += dy;
    }

    @Override
    public void zoomRelative(double fact) {
        this.zoom(this.zoomFactor * (1.0 / fact));
    }

    @Override
    public void zoom(double fact, double x, double y) {
        this.move0(x - this.xm, y - this.ym);
        this.zoom0(fact);
        this.fireDisplayUpdated();
    }

    @Override
    public void zoom(double fact) {
        this.zoom0(fact);
        this.fireDisplayUpdated();
    }

    private void zoom0(double fact) {
        this.zoomFactor = fact;
        if (this.intelliZoom) {
            double ticksx = 7.0;
            double ticksy = 7.0;
            double lx = this.getXMax() - this.getXMin();
            double ly = this.getYMax() - this.getYMin();
            this.xscl = Math.pow(10.0, 10.0);
            while (ticksx > lx / this.xscl) {
                this.xscl /= 10.0;
            }
            this.yscl = Math.pow(10.0, 10.0);
            while (ticksy > ly / this.yscl) {
                this.yscl /= 10.0;
            }
            this.plotStep = this.xscl / 10.0;
        }
    }

    @Override
    public void zoomHorizontal(double fact) {
        this.xr *= 1.0 / fact;
        this.fireDisplayUpdated();
    }

    @Override
    public void zoomVertical(double fact) {
        this.yr *= 1.0 / fact;
        this.fireDisplayUpdated();
    }

    @Override
    public double getXMax() {
        return this.xm + this.zoomFactor * this.xr;
    }

    @Override
    public double getXMin() {
        return this.xm - this.zoomFactor * this.xr;
    }

    @Override
    public double getXScl() {
        return this.xscl;
    }

    @Override
    public double getYMax() {
        return this.ym + this.zoomFactor * this.yr;
    }

    @Override
    public double getYMin() {
        return this.ym - this.zoomFactor * this.yr;
    }

    @Override
    public double getYScl() {
        return this.yscl;
    }

    @Override
    public double getZoom() {
        return 1.0 / this.zoomFactor;
    }
}

